#ifndef _cg_noise_h
#define _cg_noise_h

/******************************************************************************/
/*** A basic Noise implementation                                           ***/
/***                                                                        ***/
/*** All noise functions are band-limited.  The frequency is 1.0 and the    ***/
/*** output range is always [0, 1].                                         ***/
/******************************************************************************/

/* The noise repeats at this interval in its' domain */
extern const int RepeatInterval;

/* Base noise functions */
extern double cgNoise1(double t);
extern double cgNoise2(double u, double v);
extern double cgNoise3(double u, double v, double w);

/* Turbulence functions.  Multiple octaves of the cgNoise() functions */
extern double cgFbm1(double t, int octaves, double lambda, double omega);
extern double cgFbm2(double u, double v, int octaves, double lambda, double omega);
extern double cgFbm3(double u, double v, double w, int octaves, double lambda, 
                      double omega);

#endif
