.if defined(LIB) && defined(SHLIB_MAJOR)
SHLIB_NAME?=	lib${LIB}.so.${SHLIB_MAJOR}
.endif
.if defined(SHLIB_NAME)
SHLIB_LINK?=	${SHLIB_NAME:R}
.endif
.if defined(STATIC_LIB) && ${STATIC_LIB} == "true"
STATICLIB_NAME?=     lib${LIB}.a
.endif

.if !defined(OBJDIR)
OBJDIR=		obj
.endif

all:   # dummy rule
clean: # dummy rule

install:
.if defined(SHLIB_NAME)
	@rm -f ${DESTDIR}${LIBDIR}/${SHLIB_NAME}
	@${INSTALL} -C -o ${LIBOWN} -g ${LIBGRP} -m ${LIBMODE} \
		${NVIDIA_ROOT}/${OBJDIR}/${SHLIB_NAME} \
		${DESTDIR}${LIBDIR}
.endif
.if defined(SHLIB_LINK)
	@rm -f ${DESTDIR}${LIBDIR}/${SHLIB_LINK}
	@ln -fs ${SHLIB_NAME} ${DESTDIR}${LIBDIR}/${SHLIB_LINK}
.endif
.if defined(STATICLIB_NAME)
	@rm -f ${DESTDIR}${LIBDIR}/${STATICLIB_NAME}
	@${INSTALL} -C -o ${LIBOWN} -g ${LIBGRP} -m ${LIBMODE} \
		${NVIDIA_ROOT}/${OBJDIR}/${STATICLIB_NAME} \
		${DESTDIR}${LIBDIR}
.endif

.include <bsd.init.mk>
