/* _NVRM_COPYRIGHT_BEGIN_
 *
 * Copyright 2001 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 *
 * _NVRM_COPYRIGHT_END_
 */

#ifndef __NV_FREEBSD_H__
#define __NV_FREEBSD_H__

#ifdef TRUE
#undef TRUE
#endif

#ifdef FALSE
#undef FALSE
#endif

#include <sys/param.h>

#if __FreeBSD_version > 600000
#error This driver does not support FreeBSD 6.x/-CURRENT!
#endif
#if __FreeBSD_version < 503000
#error This driver requires FreeBSD 5.3 or later!
#endif

#include <sys/systm.h>
#include <sys/types.h>
#include <sys/queue.h>
#include <sys/pciio.h>
#include <sys/vnode.h>

#include <sys/kernel.h>
#include <sys/module.h>
#include <sys/ioccom.h>
#include <sys/malloc.h>
#include <sys/socket.h>
#include <sys/sysent.h>
#include <sys/sysctl.h>

#include <machine/resource.h>
#include <machine/clock.h>
#include <machine/stdarg.h>
#include <machine/bus.h>
#include <machine/bus_memio.h>

#include <sys/conf.h>
#include <sys/rman.h>
#include <sys/proc.h>
#include <sys/lock.h>
#include <sys/mman.h>
#include <sys/file.h>
#include <sys/poll.h>

#include <sys/syscall.h>
#include <sys/bus.h>
#include <sys/memrange.h>
#include <sys/sysproto.h>
#include <sys/signalvar.h>

#include <vm/vm.h>
#include <vm/vm_param.h>
#include <vm/vm_kern.h>
#include <vm/vm_page.h>
#include <vm/vm_extern.h>
#include <vm/vm_object.h>
#include <vm/pmap.h>
#include <vm/vm_map.h>

#include <pci/agpvar.h>
#include <sys/agpio.h>

#if defined(NVCPU_X86_64)
#define NV_MMAP_TO_VM_OFFSET(_off) ((_off) | 0xfffff00000000000)
#define NV_VM_TO_MMAP_OFFSET(_off) ((_off) & 0x00000fffffffffff)
#else
#define NV_MMAP_TO_VM_OFFSET(_off) ((_off) + VM_MIN_KERNEL_ADDRESS)
#define NV_VM_TO_MMAP_OFFSET(_off) ((_off) - VM_MIN_KERNEL_ADDRESS)
#endif

#if __FreeBSD_version >= 500000
#include <sys/smp.h>
#include <dev/pci/pcireg.h>
#include <dev/pci/pcivar.h>
#include <sys/kdb.h>
#include <sys/filedesc.h>

#include <sys/lock.h>
#include <sys/mutex.h>
#include <sys/sx.h>
#include <sys/condvar.h>

#if __FreeBSD_version >= 502116
#define dev_t struct cdev*
#endif

#if defined(NVCPU_X86) && defined(PAE)
#error This driver does not support PAE enabled kernels!
#endif

#define CURTHREAD curthread

/*
 * The resource manager client tracking needs an identifier that uniquely
 * represents a client connection across threads. It needs to be specific
 * to the thread that allocated the client. The Linux struct file pointer
 * is such an identifier. The per-process file descriptor table is enough
 * on FreeBSD, due to its thread-aware reference counting.
 */

#define __TD_FDT(_td)     ((_td)->td_proc->p_fd)
#define __TD_FDT_CNT(_td) ((_td)->td_proc->p_fd->fd_refcnt)

#else
#include <machine/smp.h>
#include <pci/pcireg.h>
#include <pci/pcivar.h>

#define PCIR_HDRTYPE PCIR_HEADERTYPE

#define vm_page_lock_queues()
#define vm_page_unlock_queues()

#define VM_OBJECT_LOCK(_obj)
#define VM_OBJECT_UNLOCK(_obj)

#define pmap_invalidate_range(_pmap, _sva, _eva) invltlb()

#define pte_load(_ptep)        (*(_ptep))
#define pte_store(_ptep, _pte) (*(_ptep) = (_pte))

#define CURTHREAD curproc

/*
 * The resource manager client tracking needs an identifier that uniquely
 * represents a client connection across threads. It needs to be specific
 * to the thread that allocated the client. The Linux struct file pointer
 * is such an identifier. The per-process file descriptor table is enough
 * on FreeBSD, due to its thread-aware reference counting.
 */

#define __TD_FDT(_td)     ((_td)->p_fd)
#define __TD_FDT_CNT(_td) ((_td)->p_fd->fd_refcnt)

#endif /* __FreeBSD_version */

/*
 * The NVIDIA kernel module's malloc identifier, needed for both tracking
 * and actual allocation/freeing purposes - declared here, but defined in
 * nvidia_os.c.
 */

MALLOC_DECLARE(M_NVIDIA);

RM_STATUS os_alloc_contig_pages(void **, U032);
void os_free_contig_pages(void *, U032);

/*
 * Enable/Disable support for FreeBSD's AGP GART driver. Please note that
 * agp.ko may need to be preloaded from loader.conf; this define does not
 * influence support for NVIDIA's builtin AGP GART driver.
 */

#undef NV_SUPPORT_OS_AGP

/*
 * Decides if the FreeBSD kernel's vm86 interface is used for int10 calls
 * to the video BIOS. Since Linux does not offer this functionality, we
 * also disable it here by default; this minimizes behavioral differences
 * between the two platforms. (*** FreeBSD/i386 only! ***)
 */

#undef NV_USE_OS_VM86_INT10CALL

/*
 * This option decides if the driver will be built with support for Linux
 * or Linux 32-bit (FreeBSD/amd64) compatibility. This makes nvidia.ko
 * dependent on linux.ko; if you don't need Linux compatibility, then you
 * can safely unset this flag.
 */

#define NV_SUPPORT_LINUX_COMPAT

/*
 * Enable/Disable support for ACPI Power Management. This is untested and
 * thus disabled by default (this is 5.x/-CURRENT only).
 */

#undef NV_SUPPORT_ACPI_PM


/*
 * The DMA memory allocation tracking structure. DMA memory alloctions on
 * FreeBSD are tracked with their base address and size. Since PCI memory
 * is allocated from kernel virtual memory and since AGP allocations have
 * a contiguous range of addresses in the AGP aperture, base and size are
 * sufficient to track allocations.
 */

typedef
struct nv_alloc {
    SLIST_ENTRY(nv_alloc) list;
    u_int32_t size;
    vm_offset_t address;
    u_int32_t offset;
    struct vm_object *object;
    vm_offset_t *pte;
} nv_alloc_t;

typedef
struct nv_os_event {
    STAILQ_ENTRY(nv_os_event) queue;
    nv_event_t event;
} nv_os_event_t;

typedef
struct nv_alloc_private {
    u_int32_t count;
    u_int32_t alloc_type_contiguous;
    u_int32_t alloc_type_cached;
    u_int32_t alloc_type_kernel;
    u_int32_t class;
} nv_alloc_private_t;

typedef
struct nvidia_softc {
    device_t dev;
    device_t agp_dev;

    struct resource *BAR_recs[NV_GPU_NUM_BARS];
    int BAR_rids[NV_GPU_NUM_BARS];

    struct resource *irq;
    void *irq_ih;
    int   irq_rid;

    struct resource *iop;
    int iop_rid;

    bus_space_handle_t bs_handle;
    bus_space_tag_t bs_tag;

    dev_t cdev;
    nv_state_t *nv_state;

    /* queue of os events */
    STAILQ_HEAD(event_queue, nv_os_event) event_queue;

    struct sysctl_ctx_list sysctl_ctx;
    struct selinfo rsel;

    struct callout_handle timer_ch;

    /* list of allocations */
    SLIST_HEAD(alloc_list, nv_alloc) alloc_list;

    int refcnt;

#if __FreeBSD_version >= 500000
    struct mtx mtx_rm;
    struct sx sx_api;
#else
    int spl;
    struct lock api_lock;
#endif
} nvidia_softc_t;


#define CDEV_MAJOR      180
#define CDEV_CTL_MINOR  255

extern devclass_t nvidia_devclass;
extern nv_state_t nvidia_ctl_state;

extern const char *pNVRM_ID;

#define PCIR_CAP_LIST_ID   0x00
#define PCIR_CAP_LIST_NEXT 0x01
#define PCIR_CAP_ID_AGP    0x02
#define PCIR_CAP_ID_EXP    0x10

/*
 * Entries in the NVIDIA glue-layer registry are now described by the new
 * shared nv_parm_t structure; please review nvidia_os_registry.c in case
 * you need to make low-level configuration changes. The entries are also
 * mapped into the SYSCTL hierarchy and thus easily accessible.
 */

extern nv_parm_t nv_parms[];

/*
 * These macros extract the encoded ioctl type and number from the
 * command; we inspect the type to verify that device/control ioctls
 * originate from NVIDIA RM clients and use the number to allow the
 * core resource manager's ioctl handler to be ignorant of operating
 * specific ioctl encodings.
 */

#define __NV_IOC_TYPE(_cmd) (((_cmd) >> 8) & 0xff)
#define __NV_IOC_NR(_cmd)   (((_cmd) >> 0) & 0xff)


/* nvidia_dev.c */
int    nvidia_dev_attach     (struct nvidia_softc *);
int    nvidia_dev_detach     (struct nvidia_softc *);

/* nvidia_ctl.c */
int    nvidia_ctl_attach     (void);
int    nvidia_ctl_detach     (void);

/* nvidia_pci.c */
void   nvidia_pci_check_config_space  (device_t dev);
int    nvidia_pci_setup_intr          (device_t dev);
int    nvidia_pci_teardown_intr       (device_t dev);

#define NV_PCI_CHECK_CONFIG_SPACE(_nv) {                \
       struct nvidia_softc *__sc;                       \
       if (((_nv)->flags & NV_FLAG_CONTROL) == 0) {     \
           __sc = (_nv)->os_state;                      \
           nvidia_pci_check_config_space(__sc->dev);    \
       }                                                \
  }

/* nvidia_subr.c */
int    nvidia_attach         (device_t);
int    nvidia_detach         (device_t);
int    nvidia_suspend        (device_t);
int    nvidia_resume         (device_t);
int    nvidia_alloc          (device_t);
void   nvidia_free           (device_t);
void   nvidia_intr           (void *);
int    nvidia_modevent       (module_t, int, void *);

void   nvidia_rc_timer       (void *);

void   nv_lock_api           (nv_state_t *);
void   nv_unlock_api         (nv_state_t *);

S032   nv_alloc_contig_pages (nv_state_t *, void **, U032);
S032   nv_free_contig_pages  (nv_state_t *, void *);
S032   nv_alloc_system_pages (nv_state_t *, void **, U032);
S032   nv_free_system_pages  (nv_state_t *, void *);

S032   nv_alloc_vm_object    (nv_state_t *, void **, U032);
S032   nv_free_vm_object     (nv_state_t *, void *);

void*  nv_find_alloc         (nv_state_t *, vm_offset_t);
void*  nv_find_alloc_obj     (nv_state_t *, vm_offset_t);

S032   nv_os_agp_init        (nv_state_t *, void **, void **, U032 *);
S032   nv_os_agp_teardown    (nv_state_t *);
S032   nv_alloc_agp_pages    (nv_state_t *, void **, U032, U032, void **);
S032   nv_free_agp_pages     (nv_state_t *, void **, U032, void *);

/* nvidia_sysctl.c */
void   nvidia_sysctl_init    (void);
void   nvidia_sysctl_exit    (void);

int    nvidia_sysctl_dev_model  (SYSCTL_HANDLER_ARGS);
int    nvidia_sysctl_dev_vbios  (SYSCTL_HANDLER_ARGS);
int    nvidia_sysctl_bus_type   (SYSCTL_HANDLER_ARGS);

int    nvidia_sysctl_agp_rates      (SYSCTL_HANDLER_ARGS);
int    nvidia_sysctl_agp_fw         (SYSCTL_HANDLER_ARGS);
int    nvidia_sysctl_agp_sba        (SYSCTL_HANDLER_ARGS);
int    nvidia_sysctl_agp_registers  (SYSCTL_HANDLER_ARGS);
int    nvidia_sysctl_agp_driver     (SYSCTL_HANDLER_ARGS);

int    nvidia_sysctl_agp_status       (SYSCTL_HANDLER_ARGS);
int    nvidia_sysctl_agp_rate_status  (SYSCTL_HANDLER_ARGS);
int    nvidia_sysctl_agp_fw_status    (SYSCTL_HANDLER_ARGS);
int    nvidia_sysctl_agp_sba_status   (SYSCTL_HANDLER_ARGS);

void   nv_sysctl_init        (nv_state_t *);
void   nv_sysctl_exit        (nv_state_t *);

/* nvidia_linux.c */
void   nvidia_linux_init     (void);
void   nvidia_linux_exit     (void);

/* ioctl helpers */
int    nvidia_post_vbios      (struct nv_ioctl_post_vbios *);
int    nvidia_get_card_info   (struct nv_ioctl_card_info *);
int    nvidia_get_api_version (struct nv_ioctl_rm_api_version *);
int    nvidia_handle_ioctl    (dev_t, u_long, caddr_t, int, d_thread_t *);


/* device helpers */
int    nvidia_open_ctl       (void);
int    nvidia_open_dev       (struct nvidia_softc *);
int    nvidia_close_ctl      (dev_t, d_thread_t *);
int    nvidia_close_dev      (struct nvidia_softc *, dev_t, d_thread_t *);
int    nvidia_mmap_dev       (struct nvidia_softc *, vm_offset_t, vm_offset_t *);

#endif /* __NV_FREEBSD_H__ */

