 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-1998 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-1998 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/


 /***************************************************************************\
|*                                                                           *|
|*                         NV Architecture Interface                         *|
|*                                                                           *|
|*  <nvtypes.h> defines common widths used to access hardware in of NVIDIA's *|
|*  Unified Media Architecture (TM).                                         *|
|*                                                                           *|
 \***************************************************************************/


#ifndef NVTYPES_INCLUDED
#define NVTYPES_INCLUDED
#ifdef __cplusplus
extern "C" {
#endif

#include "cpuopsys.h"

#if defined(_H2INC) || ((defined(WIN32) || defined(_WIN32)) && !defined(_WIN32_WINNT) && !defined(_WIN32_WCE) && !defined(NV_MODS)) /* win9x */
#undef NVRM_64
#else                                             /* all other platforms */
#define NVRM_64 1
#  if defined(_WIN64) || defined(NV_64_BITS)
#    define NVRM_TRUE64 1
#  endif
#endif

#if defined(NV_UNIX) || defined(MACOS) || defined(macintosh) || defined(__APPLE_CC__) || defined(vxworks) || defined(NV_MODS) || defined(NV_QNX)
#define __int64 long long int
#endif

#if defined (NV_GOS)
#define NVRM_TRUE64 1
#define __int64 long
#endif

 /***************************************************************************\
|*                                 Typedefs                                  *|
 \***************************************************************************/

typedef unsigned char      NvV8;  /* "void": enumerated or multiple fields   */
typedef unsigned short     NvV16; /* "void": enumerated or multiple fields   */
typedef unsigned char      NvU8;  /* 0 to 255                                */
typedef unsigned short     NvU16; /* 0 to 65535                              */
typedef signed char        NvS8;  /* -128 to 127                             */
typedef signed short       NvS16; /* -32768 to 32767                         */
typedef float              NvF32; /* IEEE Single Precision (S1E8M23)         */
typedef double             NvF64; /* IEEE Double Precision (S1E11M52)        */

/* mainly for 64-bit linux, where long is 64 bits
 * and win9x, where int is 16 bit.
 */
#if defined(NV_UNIX) || defined(vxworks) || defined(_WIN32_WCE) || defined(NV_GOS)
typedef unsigned int       NvV32; /* "void": enumerated or multiple fields   */
typedef unsigned int       NvU32; /* 0 to 4294967295                         */
typedef signed int         NvS32; /* -2147483648 to 2147483647               */
#else
typedef unsigned long      NvV32; /* "void": enumerated or multiple fields   */
typedef unsigned long      NvU32; /* 0 to 4294967295                         */
typedef signed long        NvS32; /* -2147483648 to 2147483647               */
#endif

 /***************************************************************************\
|*                                                                           *|
|*  64 bit type definitions for use in interface structures.                 *|
|*                                                                           *|
 \***************************************************************************/

#if defined(NVRM_TRUE64)

typedef unsigned __int64   NvV64; /* "void": enumerated or multiple fields   */
typedef unsigned __int64   NvU64; /* 0 to 18446744073709551615               */
typedef __int64            NvS64; /* 2^-63 to 2^63-1                         */
typedef void*              NvP64; /* 64 bit void pointer                     */
typedef NvU64             NvUPtr; /* pointer sized unsigned int              */
typedef NvU64           NvOffset; /* GPU address                             */

typedef NvU64 NvU64_VALUE_T;
typedef NvP64 NvP64_VALUE_T;

#define NvU64_VALUE(n)    (n)
#define NvP64_VALUE(n)    (n)
#define NvP64_LVALUE(n)   (n)
#define NvP64_SELECTOR(n) (0)

#define NvOffset_HI32(n)  ((NvU32)((n) >> 32))
#define NvOffset_LO32(n)  ((NvU32)(n))

#elif defined(NVRM_64)

typedef unsigned __int64   NvV64; /* "void": enumerated or multiple fields   */
typedef unsigned __int64   NvU64; /* 0 to 18446744073709551615               */
typedef __int64            NvS64; /* 2^-63 to 2^63-1                         */
typedef unsigned __int64   NvP64; /* 64 bit void pointer                     */
typedef NvU32             NvUPtr; /* pointer sized unsigned int              */
typedef NvU64           NvOffset; /* GPU address                             */

typedef NvU64 NvU64_VALUE_T;
typedef NvP64 NvP64_VALUE_T;

#define NvU64_VALUE(n)    (n)
#define NvP64_VALUE(n)    ((void *)(unsigned long)(n))
#define NvP64_LVALUE(n)   (n)
#define NvP64_SELECTOR(n) (0)

#define NvOffset_HI32(n)  ((NvU32)((n) >> 32))
#define NvOffset_LO32(n)  ((NvU32)(n))

#else

/*
 * These Win9x definitions are, to put it kindly, less than ideal.  However,
 * it is unclear that there is any viable alternative.  Certain Win9x drivers
 * are built as 16-bit code (both C and assembly), and the relevant tools do
 * not support 64-bit integers.  We could easily change these definitions to
 * use 64-bit integers in 32-bit code and structures with 32-bit elements in
 * 16-bit code, but this introduces a new problem: the alignment of the
 * structures would then differ between 16-bit and 32-bit code, so when the
 * Win9x display driver made RM calls, API structures would be packed and
 * unpacked inconsistently.  The only known solutions to this problem are to
 * either manually pad the structures (very brittle) or define these types as
 * a union of a "double" and the current structures (not clear that this will
 * work either; many old compilers used to align doubles to only 4 bytes,
 * rather than 8).
 */
typedef struct {
 NvU32 low;
 NvU32 high;
}                          NvV64; /* "void": enumerated or multiple fields   */
typedef struct {
 NvU32 low;
 NvU32 high;
}                          NvU64; /* 0 to 18446744073709551615               */
typedef struct {
 NvU32 low;
 NvS32 high;
}                          NvS64; /* 2^-63 to 2^63-1                         */
typedef struct {
 NvU32 offset;
 NvU16 selector;
 NvU16 reserved;
}                          NvP64; /* 64 bit void pointer                     */

typedef NvU32             NvUPtr; /* pointer sized unsigned int              */
typedef NvU32           NvOffset; /* GPU address                             */

typedef NvU32 NvP64_VALUE_T;
typedef NvU32 NvU64_VALUE_T;

#define NvU64_VALUE(n)    ((n).low)
#define NvP64_VALUE(n)    ((n).offset)
#define NvP64_LVALUE(n)   ((n).offset)
#define NvP64_SELECTOR(n) ((n).selector)

#define NvOffset_HI32(n)  (0)
#define NvOffset_LO32(n)  (n)

#endif

/* Useful macro to hide required double cast */
#define NV_PTR_TO_NvP64(n) (NvP64_VALUE_T)(NV_UINTPTR_T)(n)

 /***************************************************************************\
|*                                                                           *|
|*  64 bit integer definitions for high precision arithmetic.                *|
|*  Ideally, NvU64/NvS64 would be a flat integer on all platforms            *|
|*  but __int64 is not recognized by 16 bit compilers.                       *|
|*                                                                           *|
 \***************************************************************************/

#if (defined(_WIN32) && !defined(_H2INC)) || defined(NVRM_64)
typedef unsigned __int64   NvUI64; /* 0 to 18446744073709551615              */
typedef __int64            NvSI64; /* 2^-63 to 2^63-1                        */
#elif defined(__GNUC__)
typedef unsigned long long int NvUI64; /* 0 to 18446744073709551615          */
typedef          long long int NvSI64; /* 2^-63 to 2^63-1                    */
#endif

/* obsolete stuff  */
/* MODS needs to be able to build without these definitions because they collide
   with some definitions used in mdiag. */
#ifndef DONT_DEFINE_U032
typedef NvV8  V008;
typedef NvV16 V016;
typedef NvV32 V032;
typedef NvU8  U008;
typedef NvU16 U016;
typedef NvU32 U032;
typedef NvU64 U064;
typedef NvS8  S008;
typedef NvS16 S016;
typedef NvS32 S032;
typedef NvS64 S064;
#endif
#if defined(MACOS) || defined(macintosh) || defined(__APPLE_CC__) || defined(NV_MODS) || defined(MINIRM) || defined(NV_UNIX) ||defined (NV_GOS)
/* more obsolete stuff */
/* need to provide these on macos9 and macosX */
#if defined(__APPLE_CC__)  /* gross but Apple osX already claims ULONG */
#undef ULONG    // just in case
#define ULONG unsigned long
#else
typedef unsigned long  ULONG;
#endif
typedef unsigned char *PUCHAR;
#endif

/* polymorphic 64-bit macros */
#if defined(NVRM_TRUE64)
typedef NvP64 VOID_PTR;
typedef NvU64 NV_UINTPTR_T;
#else
typedef NvU32 VOID_PTR;
typedef NvU32 NV_UINTPTR_T;
#endif

#if !defined(NV_PTR)
    /* Supports 32bit libraries on Win64
       See drivers\opengl\include\nvFirst.h for explanation */
#define NV_PTR
#endif

/* Aligns fields in structs  so they match up between 32 and 64 bit builds */
/* XXX Mac still uses structures without alignment -- needs to be fixed */
#if (defined(__GNUC__) || defined(NV_QNX)) && !defined(NV_MACINTOSH)
#define NV_ALIGN_BYTES(size) __attribute__ ((aligned (size)))
#else
#define NV_ALIGN_BYTES(size)
#endif

 /***************************************************************************\
|*                               Notification                                *|
 \***************************************************************************/


/***** NvNotification Structure *****/
/*
 * NV objects return information about method completion to clients via an
 * array of notification structures in main memory.
 *
 * The client sets the status field to NV???_NOTIFICATION_STATUS_IN_PROGRESS.
 * NV fills in the NvNotification[] data structure in the following order:
 * timeStamp, otherInfo32, otherInfo16, and then status.
 */


/* memory data structures */
typedef volatile struct {
 struct {                      /*                                   0000-    */
  NvU32 nanoseconds[2];        /* nanoseconds since Jan. 1, 1970       0-   7*/
 } timeStamp;                  /*                                       -0007*/
 NvV32 info32;                 /* info returned depends on method   0008-000b*/
 NvV16 info16;                 /* info returned depends on method   000c-000d*/
 NvV16 status;                 /* user sets bit 15, NV sets status  000e-000f*/
} NvNotification;
/* status values */

#if !defined(_H2INC)

 /***************************************************************************\
|*                            NvGetReport                                    *|
 \***************************************************************************/

/***** NvGetReport Structure *****/

/*
 * NV objects, starting with Kelvin, return information such as pixel counts to
 * the user via the NV*_GET_REPORT method.
 *
 * The client fills in the "zero" field to any nonzero value and waits until it
 * becomes zero.  NV fills in the timeStamp, value, and zero fields.
 */
typedef volatile struct {
    struct {                   /*                                   0000-    */
        NvU32 nanoseconds[2];  /* nanoseconds since Jan. 1, 1970       0-   7*/
    } timeStamp;               /*                                       -0007*/
    NvU32 value;               /* info returned depends on method   0008-000b*/
    NvU32 zero;                /* always written to zero            000c-000f*/
} NvGetReport;

#endif /* !defined(_H2INC) */

#ifdef __cplusplus
};
#endif

#endif /* NVTYPES_INCLUDED */
