/**
 * @file IGenericLogManager.h
 * @author Bartosz Janiak
 * 
 * @brief Contains the definition of IGenericLogManager interface.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

#include "ILogManager.h"

namespace Nvidia {
namespace Logging {

/**
 * @brief IGenericLogManager interface.
 *
 * Objects implementing this interface are responsible for transferring the formatted log
 * message to the output.
 * @tparam T Type of the formatted message.
 */
template <typename T>
class IGenericLogManager : public ILogManager
{
public:
    /// @brief Implementation of this method should transfer the formatted log message to the output.
    virtual void ManageMessage(const T& message) = 0;
};

}
}