/**
 * @file LogLevel.h
 * @author Bartosz Janiak
 * 
 * @brief Contains the definition of LogLevel enumeration and an std::ostream::operator<<() overload for it.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

#include "TStd.h"

namespace Nvidia {
namespace Logging {

/// @brief LogLevel enumeration.
enum LogLevel
{
    LogLevel_Quiet,    /// @brief setting this level will inhibit all log messages.
    LogLevel_System,
    LogLevel_Critical,
    LogLevel_Error,
    LogLevel_Warning,
    LogLevel_Debug,
    LogLevel_Info
};

}
}