/**
 * @file ILogContentsPrinter.h
 * @author Bartosz Janiak
 * 
 * @brief Contains the definitions of LoggableTraits template class.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

#include "Loggable.h"
#include "GenericSimpleLoggable.h"
#include "VectorLoggable.h"

#include <vector>

#include <boost/utility/enable_if.hpp>

namespace Nvidia {
namespace Logging {
    
    /**
     * @brief Base LoggableTraits template class.
     *
     * Used to specify which type should be used to wrap T as a Loggable.
     * Specializations are expected to define this type as a nested class
     * if it's specific to a particular T.
     */
    template <typename T>
    class LoggableTraits
    {
    public:
        ///@brief Typedef that defines which type should be used to wrap T as a Loggable.
        typedef GenericSimpleLoggable<T> LoggableType;
    };

}
}