/**
 * @file StreamManager.h
 * @author Oleg Guimaoutdinov
 * 
 * @brief Contains the definition of StreamManager class.
 *
 * Copyright  2010 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

#include "TStd.h"
#include "IGenericLogManager.h"

namespace Nvidia {
namespace Logging {

namespace Test {
    class StreamManagerTest;
}

/// @brief Log manager which outputs string messages to files.
class StreamManager : public IGenericLogManager<std::tstring>
{
    friend class Test::StreamManagerTest;

private:
    /// @brief Pointer to the stream which writes to the active log file.
    std::tostream* m_postream;

public:
    /**
     * @brief constructor
     * @param[in] a pointer to the constructed ostream instance (expected std streams like cout, wcout etc.). 
     * It is a caller responsibility to create a valid stream and destroy it afterwards when necessary. 
     * For std CRT streams (cout, cerr, clog) explicit management is not required.
     */
    StreamManager(std::tostream* postream);

    /// @brief Writes the message to m_fstream and rotates the log files, if necessary.
    virtual void ManageMessage(const std::tstring& message);
};

inline StreamManager::StreamManager(std::tostream* postream)
{
    m_postream = postream;
}

inline void StreamManager::ManageMessage(const std::tstring& message)
{
    *m_postream << message << std::endl;
}

}
}