/**
 * @file TBoostFilesystem.h
 * @author Bartosz Janiak
 * 
 * @brief Contains the typedef for boost::tpath, which is expanded to boost::wpath for unicode builds
 * and boost::path for ANSI builds.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/convenience.hpp>

namespace boost {
namespace filesystem {

#if defined (UNICODE) || defined (_UNICODE)

    typedef wpath         tpath;

#else

    typedef path          tpath;

#endif
}
}