/**
 * @file TStd.h
 * @author Bartosz Janiak
 * 
 * @brief Contains typedef's and macro definitions for tstring and related types,
 * which are expanded to wide-char versions for unicode builds and narrow-char versions for ANSI builds.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

#include <cctype>
#include <string>
#include <sstream>
#include <ostream>
#include <fstream>
#include <tchar.h>

namespace std
{
#if defined (UNICODE) || defined (_UNICODE)

    typedef wstring         tstring;
    typedef wstringstream   tstringstream;
    typedef wostringstream  tostringstream;
    typedef wostream        tostream;
    typedef wfstream        tfstream;

#define tcout wcout

#else

    typedef string          tstring;
    typedef stringstream    tstringstream;
    typedef ostringstream   tostringstream;
    typedef ostream         tostream;
    typedef fstream         tfstream;

#define tcout cout

#endif
}