#ifndef _SPLAHS_H_INCLUDED_
#define _SPLAHS_H_INCLUDED_

#include "AnimatedGif.h"
#include <string.h>
#include <gdiplus.h>

class SplashCore{
public:
	SplashCore(const HINSTANCE&);
	virtual void init(int& guiMode);
	virtual bool CheckShowSplashScreen(void);
	virtual void CloseSplashScreen();
	virtual bool CreateSplashScreen();		
	virtual void SetSelfUpdateMode(bool);
};

class Splash : public SplashCore{
public:	

	Splash(const HINSTANCE&);
	virtual void init(int& guiMode);
	virtual bool CheckShowSplashScreen(void);
	virtual void CloseSplashScreen();

private:
	bool LoadSpinner(HWND hWnd);
	static LRESULT CALLBACK WindProcedure(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
	void FreeResources(HWND hWnd);
	void SetRTLLayout(bool);
	void SetupLocalizedStrings();
	bool LoadSplashImage(void);
	bool LoadIndeterminateProgressBar(HWND hWnd);
	void SetSelfUpdateMode(bool);
	bool IsSelfUpdateMode();
	virtual bool  CreateSplashScreen();
	static DWORD WINAPI CreateCustomSplashScreen(LPVOID lpParameter);
	static Splash* m_pSplashObject;
	static Splash* GetObjectInstance();
	static std::wstring versionText;
	static std::wstring updatingText;

	HWND m_CChWnd;
	Image *m_pImage;
	ULONG_PTR m_gdiplusToken;
	CAnimatedGif *m_pSpinner;
	HINSTANCE m_hInstance;
	int m_bCustomSplashScreen;
	bool m_bUseQuadroSplash;
	bool m_bIsSelfUpdate;
};

#endif