#include "stdafx.h"
#include "7ZSfxModInt.h"
#include "Splash.h"

using namespace Gdiplus;

#pragma comment (lib, "gdiplus.lib")
#define ID_GIF_DETERMINATE_TIMER 0x1

SplashCore::SplashCore(const HINSTANCE&)
{
	//do nothing	
}

void SplashCore::init(int& guiMode)
{
	//do nothing
}

bool SplashCore::CheckShowSplashScreen(void)
{
	return false;
}

bool SplashCore::CreateSplashScreen()
{
	return false;
}

void SplashCore::CloseSplashScreen()
{
	//do nothing
}

Splash::Splash(const HINSTANCE& hInstance) : SplashCore(hInstance), m_CChWnd(NULL), m_pImage(NULL),m_gdiplusToken(NULL),
m_pSpinner(NULL), m_bCustomSplashScreen(0), m_bUseQuadroSplash(false)
{
	m_hInstance = hInstance;

#ifdef USE_QUADRO_SPLASH
	m_bUseQuadroSplash = true;
#endif

	Splash::m_pSplashObject = NULL;
}

void Splash::init(int& guiMode)
{
	if( guiMode == GUIMODE_HIDDEN )
	{
		LOG(Info, "No splash screen");
		m_bCustomSplashScreen = 0;
	}
	else
	{
		LOG(Info, "Will show splash screen");
		m_bCustomSplashScreen = 1;
		guiMode = GUIMODE_HIDDEN;
	}

	m_pSplashObject = this;
}

bool Splash::CreateSplashScreen()
{
	HANDLE hThread = NULL;

	if(m_bCustomSplashScreen == 1)
	{
		DWORD myThreadID;
		hThread = CreateThread(NULL, 0, CreateCustomSplashScreen, NULL, 0, &myThreadID);

		if(hThread != NULL)
		{
			LOG(Info, "Successfully created splash screen thread");
		}
		else
		{
			LOG(Warning, "Couldn't create custom splash screen thread");
		}
	}

	return hThread != NULL;
}

bool Splash::CheckShowSplashScreen()
{
	return true;
}

void Splash::CloseSplashScreen()
{
	if(m_bCustomSplashScreen == 1)
	{
		SendMessage(m_CChWnd, WM_CLOSE, NULL, NULL);
	}
}

bool Splash::LoadSpinner(HWND hWnd)
{
#ifdef NOUAC
	//No need to show spinner.
	//return true;
#endif

	if(m_pSpinner != NULL)
	{
		return true;
	}
	LOG(Info, "Initializing spinner animation.");
	HGLOBAL		hGlobal;
	LPSTREAM	pStream;
	HRSRC	hRsrc = FindResource(NULL,MAKEINTRESOURCE(IDR_GIF2),L"GIF");
	HGLOBAL	hGlob1 = LoadResource(NULL,hRsrc);

	int	size = SizeofResource(NULL,hRsrc);
	hGlobal = GlobalAlloc(GMEM_FIXED,size);
	LPVOID	resPtr = LockResource(hGlob1);
	memcpy(hGlobal,resPtr,size);
	FreeResource(hGlob1);
	CreateStreamOnHGlobal(hGlobal,true,&pStream);

	m_pSpinner = new CAnimatedGif(pStream);
	if(m_pSpinner == NULL)
	{
		return false;
	}

	POINT pos;
	pos.x= 115;
	pos.y= 260;
	m_pSpinner->InitAnimation(hWnd, pos);
	LOG(Info, "Spinner animation initialized.");
	return true;
}

bool Splash::LoadIndeterminateProgressBar(HWND hWnd)
{
	if(m_pSpinner != NULL)
	{
		delete m_pSpinner;
		m_pSpinner = NULL;
	}
	InvalidateRect(hWnd, 0, TRUE);
	LOG(Info, "Initializing indeterminate progress bar animation.");
	HGLOBAL		hGlobal;
	LPSTREAM	pStream;
	HRSRC	hRsrc = FindResource(NULL,MAKEINTRESOURCE(IDR_GIF2),L"GIF");
	HGLOBAL	hGlob1 = LoadResource(NULL,hRsrc);

	int	size = SizeofResource(NULL,hRsrc);
	hGlobal = GlobalAlloc(GMEM_FIXED,size);
	LPVOID	resPtr = LockResource(hGlob1);
	memcpy(hGlobal,resPtr,size);
	FreeResource(hGlob1);
	CreateStreamOnHGlobal(hGlobal,true,&pStream);

	m_pSpinner = new CAnimatedGif(pStream);
	if(m_pSpinner == NULL)
	{
		return false;
	}

	POINT pos;
	pos.x= 115;
	pos.y= 260;
	m_pSpinner->InitAnimation(hWnd, pos);
	LOG(Info, "Indeterminate progress bar initialized.");
	return true;
}

bool Splash::LoadSplashImage()
{
	if(m_pImage != NULL)
	{
		LOG(Info, "m_pImage already initialized");
		return true;
	}
	
	ULONG resID = m_bUseQuadroSplash ? IDB_PNG2 : IDB_PNG1;

#ifdef NOUAC
	resID = IDB_PNG3; 
#endif

	HRSRC	hRsrc = FindResource(NULL, MAKEINTRESOURCEW(resID),L"PNG");
	HGLOBAL	hGlob1 = LoadResource(NULL,hRsrc);
	int	size = SizeofResource(NULL,hRsrc);
	HGLOBAL		hGlobal;
	LPSTREAM	pStream;

	hGlobal = GlobalAlloc(GMEM_FIXED,size);
	LPVOID	resPtr = LockResource(hGlob1);
	memcpy(hGlobal,resPtr,size);
	FreeResource(hGlob1);
	CreateStreamOnHGlobal(hGlobal,true,&pStream);

	m_pImage = new Image(pStream);
	if(m_pImage == NULL)
	{
		return false;
	}
	LOG(Info, "Splash image loading successful");
	return true;
}

void Splash::FreeResources(HWND hWnd)
{
	if(m_pSpinner != NULL)
	{
		delete m_pSpinner;
		m_pSpinner = NULL;
	}
	if(m_pImage != NULL)
	{
		delete m_pImage;
		m_pImage = NULL;
	}
	if(m_gdiplusToken != NULL)
	{
		GdiplusShutdown(m_gdiplusToken);
	}
}

LRESULT CALLBACK Splash::WindProcedure(HWND hWnd, UINT Msg,
									   WPARAM wParam, LPARAM lParam)
{
	HDC hDC;
	PAINTSTRUCT Ps;
	Graphics *graphics;

	Splash* pSplash = (Splash*) GetObjectInstance();

	if(!pSplash)
		return false;

	switch(Msg)
	{
	case WM_CREATE:
		//if(pSplash->LoadSplashImage() == false || pSplash->LoadSpinner(hWnd) == false)
		if(pSplash->LoadSplashImage() == false || pSplash->LoadIndeterminateProgressBar(hWnd) == false)
		{
			LOG(Error, "Could not load splash screen.");
			pSplash->FreeResources(hWnd);
			DestroyWindow(pSplash->m_CChWnd);
		}
		SetTimer(hWnd, ID_GIF_DETERMINATE_TIMER, 20000, NULL);
		return 0;
	case WM_PAINT:
		hDC = BeginPaint(hWnd, &Ps);
		graphics = new Graphics(hDC);
		if(pSplash->m_pImage != NULL)
		{
			graphics->DrawImage(pSplash->m_pImage, 0, 0, pSplash->m_pImage->GetWidth(), pSplash->m_pImage->GetHeight());
		}
		delete(graphics);
		EndPaint(hWnd, &Ps);
		return 0;
	case WM_TIMER:
		switch(wParam)
		{
		case ID_GIF_DETERMINATE_TIMER:
			pSplash->LoadIndeterminateProgressBar(hWnd);
			KillTimer(hWnd, ID_GIF_DETERMINATE_TIMER);
			break;
		}
		return 0;
	case WM_CLOSE:
		pSplash->FreeResources(hWnd);
		break;
	}
	return DefWindowProc(hWnd, Msg, wParam, lParam);
}

DWORD WINAPI Splash::CreateCustomSplashScreen(LPVOID lpParameter)
{
	Splash* pSplash = (Splash*) GetObjectInstance();

	if(!pSplash)
		return false;


	WNDCLASSEX  WndCls;
	static wchar_t szAppName[] = TEXT("NVIDIA Installer Splash");
	MSG         Msg;

	WndCls.cbSize        = sizeof(WndCls);
	WndCls.style         = CS_OWNDC | CS_VREDRAW | CS_HREDRAW;
	WndCls.lpfnWndProc   = &Splash::WindProcedure;
	WndCls.cbClsExtra    = 0;
	WndCls.cbWndExtra    = 0;
	WndCls.hInstance     = pSplash->m_hInstance;
	WndCls.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
	WndCls.hCursor       = LoadCursor(NULL, IDC_ARROW);
	WndCls.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	WndCls.lpszMenuName  = NULL;
	WndCls.lpszClassName = szAppName;
	WndCls.hIconSm       = LoadIcon(pSplash->m_hInstance, IDI_APPLICATION);
	RegisterClassEx(&WndCls);

	GdiplusStartupInput gdiplusStartupInput;
	Status st = GdiplusStartup(&pSplash->m_gdiplusToken, &gdiplusStartupInput, NULL);

	if (st != Ok)
	{
		return false;
	}

#ifndef NOUAC
	pSplash->m_CChWnd = CreateWindowEx(WS_EX_TOOLWINDOW,
		szAppName,
		TEXT("NVIDIA Installer Splash"),
		WS_POPUP | WS_VISIBLE,
		GetSystemMetrics(SM_CXSCREEN)/2-155,
		GetSystemMetrics(SM_CYSCREEN)/2-78,
		310,
		156,
		NULL,
		NULL,
		pSplash->m_hInstance,
		NULL);
#else
	pSplash->m_CChWnd = CreateWindowEx(WS_EX_TOOLWINDOW,
		szAppName,
		TEXT("NVIDIA Installer Splash"),
		WS_POPUP | WS_VISIBLE,
		GetSystemMetrics(SM_CXSCREEN)/2-155,
		GetSystemMetrics(SM_CYSCREEN)/2-78,
		497/*pSplash->m_pImage->GetWidth()*/,
		317/*pSplash->m_pImage->GetHeight()*/,
		NULL,
		NULL,
		pSplash->m_hInstance,
		NULL);
#endif

	SetWindowLong(pSplash->m_CChWnd, GWL_STYLE, 0);
	ShowWindow(pSplash->m_CChWnd, SW_SHOW); //display window
	UpdateWindow(pSplash->m_CChWnd);

	while(GetMessage(&Msg, NULL, 0, 0) )
	{
		TranslateMessage(&Msg);
		DispatchMessage( &Msg);
	}

	return static_cast<int>(Msg.wParam);
}
Splash* Splash::m_pSplashObject = NULL;
Splash* Splash::GetObjectInstance()
{
	return m_pSplashObject;
}
