#ifndef _SPLAHS_H_INCLUDED_
#define _SPLAHS_H_INCLUDED_

#include "AnimatedGif.h"
#include <gdiplus.h>

class SplashCore{
public:
	SplashCore(const HINSTANCE&);
	virtual void init(int& guiMode);
	virtual bool CheckShowSplashScreen(void);
	virtual void CloseSplashScreen();
	virtual bool CreateSplashScreen();		
};

class Splash : public SplashCore{
public:	

	Splash(const HINSTANCE&);
	virtual void init(int& guiMode);
	virtual bool CheckShowSplashScreen(void);
	virtual void CloseSplashScreen();

private:
	bool LoadSpinner(HWND hWnd);
	static LRESULT CALLBACK WindProcedure(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
	void FreeResources(HWND hWnd);
	bool LoadSplashImage(void);
	bool LoadIndeterminateProgressBar(HWND hWnd);
	virtual bool  CreateSplashScreen();
	static DWORD WINAPI CreateCustomSplashScreen(LPVOID lpParameter);
	static Splash* m_pSplashObject;
	static Splash* GetObjectInstance();

	HWND m_CChWnd;
	Image *m_pImage;
	ULONG_PTR m_gdiplusToken;
	CAnimatedGif *m_pSpinner;
	HINSTANCE m_hInstance;
	int m_bCustomSplashScreen;
	bool m_bUseQuadroSplash;
};

#endif