/**
 * @file CompositeLoggable.h
 * @author Bartosz Janiak
 * 
 * @brief Contains the definition of CompositeLoggable abstract class.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

#include "Loggable.h"

namespace Nvidia {
namespace Logging {

class LogContentsPrinter;

/**
 * @brief Base class for Loggable%s with a state consisting of more than one value.
 *
 * User-defined classes which are meant to be used in the logging system should inherit from this class.
 */
class CompositeLoggable : public Loggable
{
public:
    /**
     * @brief Passes all the elements of this CompositeLoggable to the LogContentsPrinter instance
       via LogContent() method.
     */
    virtual void LogContentsOn(LogContentsPrinter& logContentsPrinter) const = 0;
};

}
}