/**
 * @file DebugOutputLogManager.h
 * @author Bartosz Janiak
 * 
 * @brief Contains the definition of DebugOutputLogManager class.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

#include "TStd.h"

#include "RegistryKey.h"
#include "IGenericLogManager.h"

namespace Nvidia {
namespace Logging {

/// @brief Log manager which outputs the messages via OutputDebugString() system call.
class DebugOutputLogManager : public IGenericLogManager<std::tstring>
{
public:
    /// @brief Default empty constructor.
    DebugOutputLogManager();
    /// @brief Empty constructor.
    DebugOutputLogManager(const RegistryKey& key);
    /// @brief Passes the message to OutputDebugString() system call.
    virtual void ManageMessage(const std::tstring& message);
    
};

inline DebugOutputLogManager::DebugOutputLogManager() {}

inline DebugOutputLogManager::DebugOutputLogManager(const RegistryKey&) {}

inline void DebugOutputLogManager::ManageMessage(const std::tstring& message)
{
    OutputDebugString((message + _T("\n")).c_str());
}

}
}