/**
 * @file ILogPrinter.h
 * @author Bartosz Janiak
 * 
 * @brief Contains the definition of ILogPrinter interface.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

namespace Nvidia {
namespace Logging {

class LogInfo;
class CompositeLoggable;
class ILogManager;

/**
 * @brief ILogPrinter interface.
 *
 * This interface has been created to hide the template parameter T of the GenericLogPrinter
 * from the Logger. New log printers implementations shouldn't implement this interface directly,
 * they should inherit from GenericLogPrinter instead.
 */
class ILogPrinter
{
public:
    /// @brief Prints the formatted message on all registered ILogManager%s.
    virtual void PrintMessage(const LogInfo& logInfo, const CompositeLoggable& message) = 0;

    /**
     * @brief Adds the ILogManager instance to this ILogPrinter.
     *
     * It's not the ILogPrinter, but the Logger that maintains the life cycle of the
     * ILogManager instances. This is because ILogManager instances can be shared
     * between different ILogPrinters.
     */
    virtual void AddLogManager(ILogManager* logManager) = 0;

    /// @brief Dummy virtual destructor to ensure correct cleanup of implementations
    virtual ~ILogPrinter();
};

inline ILogPrinter::~ILogPrinter() {};

}
}