/**
 * @file TBoostFormat.h
 * @author Bartosz Janiak
 * 
 * @brief Contains the typedef for boost::tformat, which is expanded to boost::wformat for unicode builds
 * and boost::format for ANSI builds.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

#include <boost/format.hpp>

namespace boost
{
#if defined (UNICODE) || defined (_UNICODE)

    typedef wformat         tformat;

#else

    typedef format          tformat;

#endif
}