/**
 * @file ChainLoggableTest.h
 * @author Bartosz Janiak
 * 
 * @brief
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once
#include "MockWinApi.h"
#include "cxxtest/TestSuite.h"
#include "TestObjects.h"
#include <Logging.h>

#include <boost/assign/std/vector.hpp>

namespace Nvidia {
namespace Logging {
namespace Test {

using namespace boost::assign; // bring 'operator+=()' into scope

class ChainLoggableTest : public CxxTest::TestSuite
{
public:
    void TestGetStringValue()
    {
        TestLoggable testLoggable;
        GenericSimpleLoggable<double> loggable(3.14);
        std::vector<int> vector;
        vector += 2, 5, 8;

        std::tstring expectedResult(std::tstring(_T("42 ")) + testLoggable.GetStringValue() + 
            _T(" vector<int> ") + loggable.GetStringValue() + _T(" string"));

        TS_ASSERT_EQUALS(MakeChainLoggable(MakeEmptyChain() + 42 + testLoggable + vector +
            loggable + _T("string")).GetStringValue(), expectedResult);
    }

    void TestLogContentsOn()
    {
        TestLoggable testLoggable;
        GenericSimpleLoggable<double> loggable(3.14);
        std::vector<int> vector;
        vector += 2, 5, 8;

        TestLogContentsPrinter testLogContentsPrinter;

        MakeChainLoggable(MakeEmptyChain() + 42 + testLoggable + vector + loggable + _T("string"))
            .LogContentsOn(testLogContentsPrinter);

        std::vector<std::pair<std::tstring, std::tstring> > expectedContents;
        expectedContents += std::make_pair(_T(""), _T("42")),
                            std::make_pair(_T(""), testLoggable.GetStringValue()),
                            std::make_pair(_T(""), _T("vector<int>")),
                            std::make_pair(_T(""), loggable.GetStringValue()),
                            std::make_pair(_T(""), _T("string"));
        
        TS_ASSERT_EQUALS(testLogContentsPrinter.GetContents(), expectedContents);
    }
};

}
}
}

using namespace Nvidia::Logging::Test;