/**
 * @file ChainTest.h
 * @author Bartosz Janiak
 * 
 * @brief
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once
#include "MockWinApi.h"
#include "cxxtest/TestSuite.h"
#include <Logging.h>
#include <vector>
#include <TStd.h>

#include <boost/assign/std/vector.hpp>

namespace Nvidia {
namespace Logging {
namespace Test {

using namespace boost::assign; // bring 'operator+=()' into scope

class ChainTest : public CxxTest::TestSuite
{
public:
    void TestOperatorPlusArithmetic()
    {
        int int42 = 42;
        TS_ASSERT_EQUALS((MakeEmptyChain() + 42).GetHead(), 42);
        TS_ASSERT_EQUALS((MakeEmptyChain() + int42).GetHead(), 42);

        float pi = 3.14f;
        double piDouble = 3.14;
        TS_ASSERT_EQUALS((MakeEmptyChain() + 3.14).GetHead(), 3.14);
        TS_ASSERT_EQUALS((MakeEmptyChain() + pi).GetHead(), (float)3.14);
        TS_ASSERT_EQUALS((MakeEmptyChain() + piDouble).GetHead(), (double)3.14);
    }

    void TestOperatorPlusVector()
    {
        std::vector<int> vector;
        vector += 42, 4, 2;
        TS_ASSERT_EQUALS(&((MakeEmptyChain() + vector).GetHead()), &vector);
    }

    void TestOperatorPlusConstChar()
    {
        const TCHAR* string = _T("someString");
        TS_ASSERT_EQUALS(_tcscmp((MakeEmptyChain() + _T("someString")).GetHead(), _T("someString")), 0);
        TS_ASSERT_EQUALS((MakeEmptyChain() + string).GetHead(), string);
    }

    void TestOperatorPlusString()
    {
        std::tstring string(_T("someString"));
        TS_ASSERT_EQUALS((MakeEmptyChain() + string).GetHead(), std::tstring(_T("someString")));
        TS_ASSERT_EQUALS((MakeEmptyChain() + string).GetHead(), string);
    }
};

}
}
}

using namespace Nvidia::Logging::Test;