/**
 * @file FormattedChainLoggableTest.h
 * @author Bartosz Janiak
 * 
 * @brief
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once
#include "MockWinApi.h"
#include "cxxtest/TestSuite.h"
#include "TestObjects.h"
#include <Logging.h>
#include <boost/format.hpp>
#include <boost/assign/std/vector.hpp>

namespace Nvidia {
namespace Logging {
namespace Test {

using namespace boost::assign; // bring 'operator+=()' into scope

class FormattedChainLoggableTest : public CxxTest::TestSuite
{
public:
    void TestGetStringValue()
    {
        TestLoggable testLoggable;
        GenericSimpleLoggable<double> loggable(3.14);
        std::vector<int> vector;
        vector += 2, 5, 8;

        std::tstring format(_T("%08X:%s_%s^^^%15.10f  %s"));
        std::tstring expectedResult = (boost::tformat(format) % 42 % testLoggable % vector % loggable % _T("string")).str() ;

        TS_ASSERT_EQUALS(MakeFormattedChainLoggable(MakeEmptyChain() + 42 + testLoggable + vector + loggable + _T("string"), format)
            .GetStringValue(), expectedResult);
    }
};

}
}
}

using namespace Nvidia::Logging::Test;