/**
 * @file OldSimpleTest.h
 * @author Bartosz Janiak
 * 
 * @brief
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once
#include "MockWinApi.h"
#include "cxxtest/TestSuite.h"
#include "TestObjects.h"
#include <Logging.h>
#include <iostream>
#include <iomanip>
#include <boost/assign/std/vector.hpp>
using namespace boost::assign; // bring 'operator+=()' into scope

class OldSimpleTest : public CxxTest::TestSuite
{
public:
    DEFINE_LOGGER(_T("classLogger"));

    void testClassLogger()
    {
        Nvidia::Logging::GenericSimpleLoggable<float> loggable(3.14f);    
        Nvidia::Logging::Test::TestLoggable testLoggable;
        std::vector<int> vector;
        vector += 2, 5, 8;

        for ( int i = 0 ; i < 100 ; i++ )
        {
            LOG(Critical, testLoggable + 13 + loggable + vector + _T("foobar"));
            LOGF(Error  , _T("%.1f .:. %f *** %s: %x"), 5.623 + boost::io::group(std::left, std::setw(20), 3.21) + _T("abc") + 0x42);
            LOGF(Warning, _T("%.1f .:. %010.6d *** %s: %x"), 5.623 + 3.21 + _T("abc") + 0x42);
            LOGF(Debug  , _T("%.1f .:. %010.6d *** %s: %x"), 5.623 + 3.21 + _T("abc") + 0x42);
            LOGF(Info   , _T("%.1f .:. %010.6d *** %s: %x"), 5.623 + 3.21 + _T("abc") + 0x42);
        }
    }

    void testFunctionLogger()
    {
        DEFINE_LOGGER(_T("functionLogger"));

        Nvidia::Logging::GenericSimpleLoggable<float> loggable(3.14f);    
        Nvidia::Logging::Test::TestLoggable testLoggable;
        std::vector<int> vector;
        vector += 2, 5, 8;

        for ( int i = 0 ; i < 100 ; i++ )
        {
            LOG(Critical, testLoggable + 13 + loggable + vector + _T("foobar"));
            LOGF(Error  , _T("%.1f .:. %010.6d *** %s: %x"), 5.623 + 3.21 + _T("abc") + 0x42);
            LOGF(Warning, _T("%.1f .:. %010.6d *** %s: %x"), 5.623 + 3.21 + _T("abc") + 0x42);
            LOGF(Debug  , _T("%.1f .:. %010.6d *** %s: %x"), 5.623 + 3.21 + _T("abc") + 0x42);
            LOGF(Info   , _T("%.1f .:. %010.6d *** %s: %x"), 5.623 + 3.21 + _T("abc") + 0x42);
        }
    }
};