/**
 * @file VectorLoggableTest.h
 * @author Bartosz Janiak
 * 
 * @brief
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once
#include "MockWinApi.h"
#include "cxxtest/TestSuite.h"
#include "TestObjects.h"
#include <Logging.h>

#include <boost/assign/std/vector.hpp>

namespace Nvidia {
namespace Logging {
namespace Test {

using namespace boost::assign; // bring 'operator+=()' into scope

class VectorLoggableTest : public CxxTest::TestSuite
{
public:
    void TestGetStringValue()
    {
        std::vector<int> vector;
        
        vector += 2, 5, 8;

        TS_ASSERT_EQUALS(VectorLoggable<std::vector<int>::iterator>(vector.begin(), vector.end()).GetStringValue(), _T("vector<int>"));
    }

    void TestLogContentsOn()
    {
        std::vector<int> vector;
        vector += 2, 5, 8;

        TestLogContentsPrinter testLogContentsPrinter;

        VectorLoggable<std::vector<int>::iterator>(vector.begin(), vector.end()).LogContentsOn(testLogContentsPrinter);

        std::vector<std::pair<std::tstring, std::tstring> > expectedContents;
        expectedContents += std::make_pair(_T(""), _T("2")),
                            std::make_pair(_T(""), _T("5")),
                            std::make_pair(_T(""), _T("8"));
        
        TS_ASSERT_EQUALS(testLogContentsPrinter.GetContents(), expectedContents);
    }
};

}
}
}

using namespace Nvidia::Logging::Test;