/**
 * @file GenericSimpleLoggable.h
 * @author Bartosz Janiak
 * 
 * @brief Contains the definition of GenericSimpleLoggable class.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

#include "Loggable.h"

#include "TStd.h"

#include <boost/lexical_cast.hpp>

namespace Nvidia {
namespace Logging {

/**
 * @brief Used to wrap simple, built-in types (int, std::string, etc.) as a Loggable.
 *
 * @tparam T Type of the wrapped value.
 */
template <typename T>
class GenericSimpleLoggable : public SimpleLoggable
{
protected:
    /// @brief Wrapped value.
    T Value;
public:
    /// @brief Constructor. Sets the wrapped value.
    GenericSimpleLoggable(T value) : Value(value) {}

    /// @brief Returns the string representation of the wrapped value.
    virtual std::tstring GetStringValue() const
    {
        return boost::lexical_cast<std::tstring>(Value);
    }

    /// @brief Returns the string representation of the type of the wrapped value.
    virtual std::tstring GetTypeName() const
    {
        return boost::lexical_cast<std::tstring>(typeid(Value).name());
    }
};

}
}