/**
 * @file ILogManager.h
 * @author Bartosz Janiak
 * 
 * @brief Contains the definition of ILogManager interface.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

namespace Nvidia {
namespace Logging {

/**
 * @brief ILogManager interface.
 *
 * This interface has been created to hide the template parameter T of the IGenericLogManager
 * from the Logger. New log managers implementations shouldn't implement this interface directly,
 * they should implement IGenericLogManager instead.
 */
class ILogManager
{
public:
    /// @brief Enables/Disables write-through in this log manager
    virtual void EnableWriteThrough(bool = true)
    {
        // No-op by default
    }

    /// @brief Dummy virtual destructor to make ILogManager polymorphic.
    virtual ~ILogManager();
};

inline ILogManager::~ILogManager() {};

}
}