/**
 * @file Logging.h
 * @author Bartosz Janiak
 * 
 * @brief Public header which should be included by users of the logging system.
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */


#if defined(_X86_) || defined(_AMD64_) || defined(_IA64_)

#pragma once
#pragma warning (push)
#pragma warning (disable: 4244) // 'conversion' conversion from 'type1' to 'type2', possible loss of data
#pragma warning (disable: 4634) // XML document comment: cannot be applied
#pragma warning (disable: 4635) // XML document comment target: badly-formed XML
#pragma warning (disable: 6011) // Dereferencing NULL pointer; Ignore analysis reports in Boost headers
#include "ScopeLogger.h"
#pragma warning (pop)


#else

//
// Logging not currently support on non-x86 platforms, 
// this stubs out the logging definitions
//
class Logger
{
public:
    class Element
    {
    public:
        template<typename T>
        const Element operator + (const T &) const { return *this; }
    };

    static void Log(const Element &) { }
};

#define LOG(level, msg) Logger::Log(Logger::Element() + msg)
#define SCOPE_LOG(msg) Logger::Log(Logger::Element() + msg)
#define DEFINE_LOGGER(msg)
#define DEFINE_SCOPE_LOGGER()
#define ENABLE_LOG_WRITETHROUGH()

#endif
