/**
 * @file MiscellaneousTest.h
 * @author Bartosz Janiak
 * 
 * @brief
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once
#include "MockWinApi.h"
#include "cxxtest/TestSuite.h"
#include "TestObjects.h"
#include <Logging.h>

namespace Nvidia {
namespace Logging {
namespace Test {

class MiscellaneousTest : public CxxTest::TestSuite
{
public:
    void TestGenericSimpleLoggable()
    {
        TS_ASSERT_EQUALS(GenericSimpleLoggable<int>(123).GetStringValue(), std::tstring(_T("123")));
        TS_ASSERT_EQUALS(GenericSimpleLoggable<int>(123).GetTypeName(), std::tstring(_T("int")));
    }

    void TestLogLevelOstreamOperator()
    {
        std::tostringstream stream;
        stream << LogLevel_System << _T(" ") << LogLevel_Critical << _T(" ") << LogLevel_Error << _T(" ") << LogLevel_Warning << _T(" ") << LogLevel_Debug << _T(" ") << LogLevel_Info;
        TS_ASSERT_EQUALS(stream.str(), std::tstring(_T("System Critical Error Warning Debug Info")));
    }
};

}
}
}

using namespace Nvidia::Logging::Test;
