/**
 * @file TestObjects.h
 * @author Bartosz Janiak
 * 
 * @brief
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once

#include "MockWinApi.h"
#include <Logging.h>
#include <IGenericLogManager.h>
#include <boost/lexical_cast.hpp>
#include <boost/assign/std/vector.hpp>
using namespace boost::assign; // bring 'operator+=()' into scope

namespace Nvidia {
namespace Logging {
namespace Test {

class TestLoggable2 : public CompositeLoggable {
public:
    virtual void LogContentsOn(LogContentsPrinter& logContentsPrinter) const
    {
        logContentsPrinter.LogContent(_T("id"), _T("abc"));
        logContentsPrinter.LogContent(_T("doubleField"), 9.87);
    }

    virtual std::tstring GetStringValue() const 
    {
        return GetHumanReadableTypeName() + _T("_abc");
    }
};

class TestLoggable : public CompositeLoggable {
private:
    std::vector<std::tstring> Vector;

public:
    TestLoggable()
    {
        Vector += _T("firstString"), _T("secondString");
    }
    virtual void LogContentsOn(LogContentsPrinter& logContentsPrinter) const
    {
        logContentsPrinter.LogContent(_T("id"), _T("123"));
        logContentsPrinter.LogContent(_T("someField1"), 154);
        logContentsPrinter.LogContent(_T("someField2"), TestLoggable2());
        logContentsPrinter.LogContent(_T("vectorField"), Vector);
    }

    virtual std::tstring GetStringValue() const 
    {
        return GetHumanReadableTypeName() + _T("123");
    }
};

class TestLogContentsPrinter : public LogContentsPrinter {
private:
    std::vector<std::pair<std::tstring, std::tstring> > Contents;
public:
    
    virtual void LogContentInternal(const std::tstring& name, const SimpleLoggable& loggable)
    {
        Contents.push_back(std::make_pair(name, loggable.GetStringValue()));
    }

    virtual void LogContentInternal(const std::tstring& name, const CompositeLoggable& loggable)
    {
        Contents.push_back(std::make_pair(name, loggable.GetStringValue()));
    }

    const std::vector<std::pair<std::tstring, std::tstring> >& GetContents() const
    {
        return Contents;
    }
};

class TestLogManager : public IGenericLogManager<std::tstring> {
private:
    std::vector<std::tstring> Messages;
public:

    virtual void ManageMessage(const std::tstring& message)
    {
        Messages.push_back(message);
    }

    const std::vector<std::tstring>& GetMessages() const
    {
        return Messages;
    }
};

}
}
}

using namespace Nvidia::Logging::Test;