/**
 * @file XMLLogPrinterTest.h
 * @author Bartosz Janiak
 * 
 * @brief
 *
 * Copyright  2009 NVIDIA Corporation. All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and proprietary
 * rights in and to this software, related documentation and any modifications thereto. Any
 * use, reproduction, disclosure or distribution of this software and related documentation
 * without express license agreement from NVIDIA Corporation is strictly prohibited.
 */

#pragma once
#include "MockWinApi.h"
#include "cxxtest/TestSuite.h"
#include "TestObjects.h"
#include <Logging.h>
#include <XMLLogPrinter.h>
#include <GenericSimpleLoggable.h>

#include <boost/assign/std/vector.hpp>
#include <boost/algorithm/string/erase.hpp>
#include <boost/lexical_cast.hpp>

namespace Nvidia {
namespace Logging {
namespace Test {

using namespace boost::assign; // bring 'operator+=()' into scope

class XMLLogPrinterTest : public CxxTest::TestSuite {
public:

    void TestComplex()
    {
        TestLoggable testLoggable;
        GenericSimpleLoggable<double> loggable(3.14);
        std::vector<int> vector;
        vector += 2, 5, 8;
        
        XMLLogPrinter logPrinter;
        TestLogManager logManager;
        logPrinter.AddLogManager(&logManager);

        std::tstring scopeLoggerName(_T("scopeLoggerName"));

        logPrinter.PrintMessage(LogInfo(LogLevel_Debug, scopeLoggerName, _T("function"), _T("file"), 123),
            MakeChainLoggable(MakeEmptyChain() + 42 + testLoggable + vector + loggable + _T("someString")));

        const std::tstring& message = logManager.GetMessages()[0];

        std::tstring expectedMessageTail(_T("\" msg=\"42 TestLoggable123 vector<int> 3.1400000000000001 someString\" origin=\"scopeLoggerName\" function=\"function\" file=\"file\" line=\"123\">\n\
    <int value=\"42\"/>\n\
    <TestLoggable id=\"123\">\n\
        <int field=\"someField1\" value=\"154\"/>\n\
        <TestLoggable2 field=\"someField2\" id=\"abc\">\n\
            <double field=\"doubleField\" value=\"9.8699999999999992\"/>\n\
        </TestLoggable2>\n\
        <vector field=\"vectorField\">\n\
            <basic_string value=\"firstString\"/>\n\
            <basic_string value=\"secondString\"/>\n\
        </vector>\n\
    </TestLoggable>\n\
    <vector>\n\
        <int value=\"2\"/>\n\
        <int value=\"5\"/>\n\
        <int value=\"8\"/>\n\
    </vector>\n\
    <double value=\"3.1400000000000001\"/>\n\
    <char value=\"someString\"/>\n\
</Debug>"));

        #if defined (UNICODE) || defined (_UNICODE)
            boost::algorithm::replace_all(expectedMessageTail, _T("char"), _T("wchar_t"));
        #endif

        TS_ASSERT_EQUALS(boost::algorithm::erase_head_copy(message, (int)(message.size() - expectedMessageTail.size())), expectedMessageTail);
    }
};

}
}
}

using namespace Nvidia::Logging::Test;