#pragma once

#include <gdiplus.h>
#include <atltypes.h>
using namespace Gdiplus;

class CAnimatedGif : public Image
{
public:

	CAnimatedGif(_In_ LPSTREAM	pStream, _In_ BOOL useEmbeddedColorManagement = FALSE);
	~CAnimatedGif(void);

    //! Initialize the gif animation thread
	BOOL InitAnimation(_In_ HWND hWnd, _In_ POINT pt);
protected:
	    //! Pause or resume the animation
	void SetPause(_In_ BOOL bPause);

	    //! Initialization function
	void Initialize(void);

	    //! Perform some test on animated gif 
    BOOL TestForAnimatedGIF(void);

	    //! Check if it is an animated gif
	BOOL IsAnimatedGIF(void) 
    { 
        return m_nFrameCount > 1; 
    }

	//! Threaded function responsible for gif animation
	void ThreadAnimation(void);

	    //! Threaded function responsible for gif animation
	static UINT WINAPI ThreadAnimationProc(_In_ LPVOID pParam);
	    //! Draw the appropriate frame from Gif
	BOOL DrawFrame(void);

protected:
	PropertyItem   *m_pPropertyItem;
    HANDLE			m_hThread;
	HANDLE			m_hPause;
	HANDLE			m_hExitEvent;
	HINSTANCE		m_hInst;
	HWND			m_hWnd;
	UINT			m_nFrameCount;
	UINT			m_nFramePosition;
	BOOL			m_bPause;
	POINT			m_pt;

private:	
    //! Clean up
	void Destroy();
};
