@echo off

@REM This is batch file to build NvApp PFW.
@REM Win32/Release build will be build.

echo.
echo ===============================================================================
echo ========================= Preparing build enviroment ==========================
echo ===============================================================================

if not exist "%BUILD_TOOLS_DIR%" goto :error_no_tools_dir
echo Using tools from %BUILD_TOOLS_DIR%

set VCVERSION=16.10.3
set VSINSTALLDIR=%BUILD_TOOLS_DIR%\win32\msvc\%VCVERSION%
if not exist %VSINSTALLDIR% goto :error_no_vs
echo Visual Studio path: %VSINSTALLDIR%
set VCINSTALLDIR=%VSINSTALLDIR%\VC
if not exist %VCINSTALLDIR% goto :error_no_vc
echo VisualC path: %VCINSTALLDIR%

echo Locating MSBuild with %VSINSTALLDIR%\Common7\Tools\VsMSBuildCmd.bat
call %VSINSTALLDIR%\Common7\Tools\VsMSBuildCmd.bat

REM Required for MSBuild to find Microsoft.Cpp.Default.props
SET VCTargetsPath=%BUILD_TOOLS_DIR%\win32\msvc\%VCVERSION%\MSBuild\Microsoft\VC\v160\

REM Required for DVS builders to find SDKs from WindowsSdkDir_10 variable below and not from registry
SET DisableRegistryUse=true

REM This "UseEnv" might be useful in future when tweaking DVS builds again to reduce warnings count. It is not strictly required right now though.
REM SET UseEnv=true

REM Builder doesn't find Spectre libs without this variable.
SET VCInstallDir_160=%VCINSTALLDIR%

set WINSDK_DIR=%BUILD_TOOLS_DIR%\sdk\WinSDK\10
set WindowsSdkDir_10=%BUILD_TOOLS_DIR%\sdk\WinSDK\10
set WINSDK_VERSION=10.0.14393.0
set WINSDK_INCLUDE_ROOT=%WindowsSdkDir_10%\Include\%WINSDK_VERSION%
if not exist "%WINSDK_DIR%" goto :nosdk_error
echo Using WinSDK from %WINSDK_DIR%

set _PATH=%PATH%

set GENERAL_BUILD_OPTIONS=/nologo ^
    /p:VCToolsVersion="14.29" ^
    /p:VCToolsInstallDir="%VCINSTALLDIR%\\" ^
    /p:WindowsSDKDir="%WindowsSdkDir_10%" ^
    /p:WindowsSDK_IncludePath="%WINSDK_INCLUDE_ROOT%\um;%WINSDK_INCLUDE_ROOT%\shared;%WINSDK_INCLUDE_ROOT%\winrt;%WINSDK_INCLUDE_ROOT%\ucrt"


echo.
echo ===============================================================================
echo =========================  Preparing X86 environment ==========================
echo ===============================================================================

set WINSDK_DIR_BIN=%WINSDK_DIR%\Bin\%WINSDK_VERSION%\x86

set PATH=%WINSDK_DIR_BIN%;%VSINSTALLDIR%\Common7\IDE;%VSINSTALLDIR%\VC\BIN;%VSINSTALLDIR%\Common7\Tools;%VSINSTALLDIR%\Common7\Tools\bin;%WindowsSdkDir_10%\bin\x86;%PATH%
rem Supporting offline toolchain...
set PATH=%VCINSTALLDIR%\redist\x86\Microsoft.VC140.CRT;%VSINSTALLDIR%\bin-support\x86;%PATH%

echo PATH: %PATH%

echo.
echo ===============================================================================
echo ========================     Starting 7zSfxMod X86 build...     ========================
echo ===============================================================================

echo building 7zSfxMod

@REM setup dependent lib properties
set BOOST_DIR=%BUILD_TOOLS_DIR%\boost\boost_1_79_0


@REM USE_SPLASH will be used to show GFNPC's splash screen
SET CL=/DUSE_SPLASH /DNOUAC


@REM call MSBuild SFX\7zSfxMod\7zSfxMod.sln /t:Rebuild /p:Configuration=LZMA;TargetFrameworkVersion=v4.8 %GENERAL_BUILD_OPTIONS% -fileLogger -fileLoggerParameters:logfile=MSBuildOutput.log -verbosity:diag %GENERAL_BUILD_OPTIONS% 
@REM call MSBuild SFX\7zSfxMod\7zSfxMod.sln /t:Rebuild /p:Configuration=LZMA2;TargetFrameworkVersion=v4.8 %GENERAL_BUILD_OPTIONS% -fileLogger -fileLoggerParameters:logfile=MSBuildOutput2.log -verbosity:diag %GENERAL_BUILD_OPTIONS% 

call MSBuild SFX\7zSfxMod\7zSfxMod.sln /t:Rebuild /p:Configuration=LZMA;TargetFrameworkVersion=v4.8  %GENERAL_BUILD_OPTIONS% 
call MSBuild SFX\7zSfxMod\7zSfxMod.sln /t:Rebuild /p:Configuration=LZMA2;TargetFrameworkVersion=v4.8 %GENERAL_BUILD_OPTIONS% 

del pfw\BinRef\Prerequisites\resources\7zsd_LZMA.sfx
del pfw\BinRef\Prerequisites\resources\7zsd_LZMA2.sfx

@REM copy .sfx files
xcopy SFX\Output\Win32\*.sfx pfw\BinRef\Prerequisites\resources\

rem Restoring original variables
set PATH=%_PATH%



